/**
 * TinyMCE Custom Print Plugin
 * Este plugin básico adiciona um botão para imprimir o conteúdo do editor.
 */
tinymce.PluginManager.add('customprint', function(editor, url) {

    /**
     * Função para imprimir o conteúdo do editor.
     */
    function doPrint() {
        // Obtém o conteúdo HTML atual do editor
        var content = editor.getContent();

        // Abre uma nova janela/aba
        var printWindow = window.open('', '_blank');

        // Cria um documento HTML simples para a impressão
        var printHtml = `
            <!DOCTYPE html>
            <html>
            <head>
                <title>Imprimir Documento</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        margin: 20mm; /* Margem para impressão */
                    }
                    /* Opcional: Inclua aqui quaisquer estilos CSS importantes do seu site
                       que você deseja que sejam aplicados na impressão */
                </style>
            </head>
            <body>
                ${content}
            </body>
            </html>
        `;

        // Escreve o conteúdo no novo documento
        printWindow.document.open();
        printWindow.document.write(printHtml);
        printWindow.document.close();

        // Espera o conteúdo ser renderizado e então imprime
        printWindow.onload = function() {
            printWindow.print();
            // printWindow.close(); // Opcional: Fechar a janela após a impressão. Alguns navegadores podem impedir isso.
        };
    }

    // Adiciona um botão à barra de ferramentas
    editor.ui.registry.addButton('customprint', {
        icon: 'print', // Usa o ícone de 'print' se disponível
        tooltip: 'Imprimir (Customizado)',
        onAction: function () {
            doPrint();
        }
    });

    // Adiciona um item de menu (opcional, mas recomendado para consistência)
    editor.ui.registry.addMenuItem('customprint', {
        text: 'Imprimir (Customizado)',
        icon: 'print',
        onAction: function() {
            doPrint();
        }
    });

    // Retorna informações sobre o plugin (opcional)
    return {
        getMetadata: function () {
            return {
                name: 'Custom Print Plugin',
                url: '#!' // Substitua pela URL real
            };
        }
    };
});
