/**
 * TinyMCE Custom Paste Plugin
 * Este plugin básico tenta replicar funcionalidades mínimas de colagem
 * caso o plugin 'paste' original não esteja disponível.
 * NÃO SUBSTITUI A FUNCIONALIDADE COMPLETA E INTELIGENTE DO PLUGIN 'paste' OFICIAL.
 */
tinymce.PluginManager.add('custompaste', function(editor, url) {

    /**
     * Tenta colar o conteúdo do clipboard no editor.
     * Prioriza HTML, caso contrário, cola texto puro.
     * @param {ClipboardEvent} e O evento de colagem (opcional, se chamado por um evento real de paste).
     */
    function doPaste(e) {
        let clipboardData = e && e.clipboardData ? e.clipboardData : null;
        let htmlContent = '';
        let textContent = '';

        if (clipboardData) {
            // Tenta obter o conteúdo como HTML
            htmlContent = clipboardData.getData('text/html');
            // Tenta obter o conteúdo como texto puro
            textContent = clipboardData.getData('text/plain');
        } else if (window.clipboardData && window.clipboardData.getData) {
            // Suporte para IE (menos robusto)
            htmlContent = window.clipboardData.getData('HTML');
            textContent = window.clipboardData.getData('Text');
        }

        // Se houver HTML, tenta inserir o HTML.
        // Cuidado: Este HTML não será limpo ou sanitizado de forma inteligente.
        if (htmlContent) {
            editor.insertContent(htmlContent);
        } else if (textContent) {
            // Se não houver HTML, ou se o HTML estiver vazio, cola como texto
            editor.insertContent(textContent);
        } else {
            // Mensagem simples se nada foi colado
            editor.notificationManager.open({
                text: 'Não foi possível colar conteúdo. O clipboard pode estar vazio ou inacessível.',
                type: 'warning',
                timeout: 3000
            });
        }

        // Previne o comportamento padrão de colagem do navegador/TinyMCE
        if (e) {
            e.preventDefault();
        }
    }

    // 1. Adiciona um botão à barra de ferramentas para simular "colar"
    editor.ui.registry.addButton('custompaste', {
        icon: 'paste', // Usa o ícone de 'paste' se disponível na sua versão do TinyMCE
        tooltip: 'Colar (Customizado)',
        onAction: function () {
            // Para acionar o paste via JS (requer permissão do navegador ou ser chamado de um evento de usuário)
            // Em muitos navegadores, 'document.execCommand('paste')' pode não funcionar sem um evento de usuário direto.
            // A melhor abordagem é forçar o usuário a usar Ctrl+V / Cmd+V
            editor.notificationManager.open({
                text: 'Use Ctrl+V (ou Cmd+V) para colar diretamente no editor.',
                type: 'info',
                timeout: 5000
            });
            // O ideal seria que o evento 'paste' real fosse acionado pelo usuário.
            // Se este botão for clicado, ele não terá acesso direto ao clipboard sem a permissão do usuário.
            // Mas podemos tentar chamar a função 'doPaste' como fallback, embora seja limitado.
            // doPaste(); // Descomente para tentar colar ao clicar, mas o acesso ao clipboard é restrito.
        }
    });

    // 2. Adiciona um item de menu (opcional)
    editor.ui.registry.addMenuItem('custompaste', {
        text: 'Colar (Customizado)',
        icon: 'paste',
        onAction: function() {
            // Mesmo aviso que o botão: idealmente Ctrl+V / Cmd+V
            editor.notificationManager.open({
                text: 'Use Ctrl+V (ou Cmd+V) para colar diretamente no editor.',
                type: 'info',
                timeout: 5000
            });
            // doPaste(); // Descomente para tentar colar ao clicar no menu.
        }
    });

    // 3. Ouve o evento 'paste' do próprio editor
    // Esta é a forma mais eficaz de capturar o conteúdo do clipboard.
    editor.on('paste', function (e) {
        doPaste(e);
    });

    // Retorna informações sobre o plugin (opcional)
    return {
        getMetadata: function () {
            return {
                name: 'Custom Paste Plugin',
                url: '#!'
            };
        }
    };
});
